const express = require("express");
const cors = require("cors");
require("dotenv").config();
const { sequelize } = require("./config/db.connection");
const app = express();
const port = process.env.PORT || 8989;
const path = require('path');
app.use(cors());
app.use(express.json()); //application/json
app.use(express.urlencoded({ extended: true }));
app.use(express.static(path.join(__dirname, 'public')));

app.use((req, res, next) => {
  res.setHeader("Access-Control-Allow-Origin", "*");
  res.setHeader(
    "Access-Control-Allow-Method",
    "OPTIONS, GET, POST, PUT, PATCH, DELETE"
  );
  res.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
  next();
});

app.use("/api", require("./routes/routes"));

sequelize
  .authenticate()
  .then(() => {
    app.listen(port);
    console.log(`Connection established on 🏃 Port http://localhost:${port}`);
  })
  .catch((err) => {
    console.log("error in app.js file", err.message);
  });
