const { Model, DataTypes } = require("sequelize");
const { sequelize } = require("../config/db.connection");

class contactUsModel extends Model { }

contactUsModel.init(
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    mobile: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    comment: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    product: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    browserName: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    osName: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    ipAddress: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    countryName: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    type: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    recapcha: {
      type: DataTypes.TEXT,
    },
    createdDate: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updateDate: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    sequelize,
    modelName: "contact_us",
    timestamps: false,
  }
);

contactUsModel.checkRecapchaUnique = async function (recapchaValue) {
  const existingRecord = await contactUsModel.findOne({
      where: { recapcha: recapchaValue },
  });
  return existingRecord === null;
};

module.exports = contactUsModel;
