const { Model, DataTypes } = require("sequelize");
const { sequelize } = require("../config/db.connection");

class newsLetterModel extends Model { }

newsLetterModel.init(
    {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true,
        },
        email: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        browserName: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        osName: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        ipAddress: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        countryName: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        type: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        isDeleted: {
            type: DataTypes.ENUM,
            values: ["0", "1"],
            defaultValue: "0",
        },
        createdDate: {
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
        },
        updateDate: {
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
        },
    },
    {
        sequelize,
        modelName: "news_letter",
        timestamps: false,
    }
);

module.exports = newsLetterModel;
