
const express = require("express");
const { contactUsApi, newsLetterApi, unsubscribedFunction, checkSubscription, clientNewsletterApi } = require("../controller/controller");
const validation = require("../utils/validation/validation");
const { newsLetterSchema } = require("../schema/newsLetterSchema");
const { contactUsSchema } = require("../schema/contactUsSchema");
const route = express.Router();

route.post("/create/contactUs", validation(contactUsSchema), contactUsApi);
route.post("/create/newsLetter", validation(newsLetterSchema), newsLetterApi);
route.post("/clientNewsletter", validation(newsLetterSchema), clientNewsletterApi);
route.post("/unsubscribedMail", unsubscribedFunction);
route.post("/checkSubscription", checkSubscription);

module.exports = route;

