const Joi = require("joi");

const newsLetterSchema = Joi.object().keys({
    email: Joi.string()
        .email({ tlds: { allow: false } })
        .pattern(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/)
        .required()
        .messages({
            "string.empty": "Please enter email",
            "string.email": "Please enter a valid email address",
            "string.pattern.base": "Please enter a valid email address",
        }),

    browserName: Joi.string().optional().allow(""),

    osName: Joi.string().optional().allow(""),

    ipAddress: Joi.string().optional().allow(""),

    countryName: Joi.string().optional().allow(""),

    type: Joi.string().optional().allow(""),
});

module.exports = {
    newsLetterSchema,
};
