const axios = require("axios");
const { getUrl } = require("./commonUrl");
const netcluesImage = "https://www.swadishworld.com/mail_imgaes/netclues.gif";
const companyImage = "https://www.swadishworld.com/mail_imgaes/f-logo.png";
const siteUrl = 'https://www.swadishworld.com/'; // Replace with your actual site URL
const siteName = 'Swadish World.'; // Replace with your actual site name
const crypto = require("crypto");

const encrypt = (data) => {
    if (process.env.ENCRYPTION == "true") {
        const cipher = crypto.createCipheriv(
            process.env.CIPHERALGORITHM,
            process.env.CIPHERSKEY,
            process.env.CIPHERVIKEY
        );
        let encryptedData = cipher.update(JSON.stringify(data), "utf-8", "hex");
        encryptedData += cipher.final("hex");
        return { data: encryptedData };
    } else {
        return { data };
    }
};

module.exports = {
    //Newsletter//

    clientNewsletterMail: async (reqBody) => {
        const toEmail = reqBody?.email;
        const encryptedEmail = encrypt(toEmail);
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear();
        const name = reqBody?.email.split("@")[0];
        const url = `${getUrl()}unsbscribeMail/${encryptedEmail?.data}`;
        const newsLetterUrl = `${getUrl()}subscribeMail/${encryptedEmail?.data}`;

        const message = `
            <html xmlns="http://www.w3.org/1999/xhtml">
                <head>
                    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                    <meta name="viewport" content="width=device-width"/>
                    <title>Congratulations! Your subscription has been confirmed.</title>
                </head>
                <body style="padding:15px;">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td valign="top">
                                <table width="600" border="0" cellpadding="0" cellspacing="0" style="font-family: Arial, Helvetica, sans-serif; background-color: #f0e7de; border-radius: 15px;">
                                    <tr>
                                        <td width="100%" style="padding:30px; text-align: center;">
                                            <a href=${siteUrl} title="${siteName}">
                                            <img src="${companyImage}" alt=${siteName} style="max-width: 180px;"/>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" valign="top" bgcolor="#fff" style="padding:0px 20px;background-color: #f0e7de;">
                                           
                                           <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="background-color: #fff; border-radius: 15px;">
                                                <tr>
                                                    <td style="padding: 25px;">
                                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                            <tr>
                                                                <td colspan="2"><b style="font-size: 18px; text-align: center;">Dear ${name},</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" valign="top">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size:16px; padding: 10px 0; text-align: left;">Please confirm your subscription by clicking on the below.</td>
                                                            </tr>
                                                            <tr>
                                                               <td align="left" valign="middle">
                                                                <a href="${newsLetterUrl}" title="Subscribe" target="_blank" style="font-family:Arial, Helvetica, sans-serif; font-size:16px; line-height:20px; font-weight:500; color: #2b2a29; text-decoration:none; padding:8px 30px; border-radius: 29px; background-color: #93c01d;">Yes, subscribe me</a>
                                                               </td>
                                                            </tr>
                                                            <br>
                                                            <br>
                                                            <tr>
                                                               <td align="left" valign="middle">
                                                                If you have not requested for the newsletter subscription, please ignore this email. You won't be subscribed if you don't click the above confirmation button.
                                                               </td>
                                                            </tr>
             
                                                        </table>
                                                    </td>
                                                </tr>
                                           </table>
                                           
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" valign="top">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="padding: 20px; text-align: center;">
                                                <tr>
                                                    <td style="font-size:18px; font-weight: 600; padding: 0 0 10px 0;">Best Regards,<br></td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 10px 0;">
                                                        <a href="${siteUrl}" target="_blank" title="@SITENAME" style="font-size: 16px;color: #1a1a1a;text-decoration: none;text-transform: uppercase;">${siteName}</a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><p style="text-align:center;font-size:16px;padding:10px  0px; margin: 0px;">Copyright © ${currentYear} ${siteName} All Rights Reserved.</p></td>
                                                </tr>
                                                
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>
            </html>
        `;

        const emailParams = {
            EmailTo: toEmail || "",
            Subject: "Please Confirm Email Subscription.",
            Message: message,
            ReplyToEmail: "",
            RelpyToName: "Reply To Name",
            CcEmail: "",
            BccEmail: "",
            AllowAttachment: "png,PNG,pdf,PDF,xls,xlsx,csv",
            // Attachment: [pdfUrl], // Attach the PDF URL here
        };

        const returnObject = {
            EmailPara: JSON.stringify(emailParams),
            SiteId: process.env.NMAIL_SITE_ID,
            SiteTocken: process.env.NMAIL_SITE_TOKEN,
        };

        const headers = {
            Authorization: process.env.NMAIL_HEADER_TOKEN,
        };

        try {
            const response = await axios.post(
                process.env.NMAIL_URL,
                returnObject,
                {
                    headers,
                }
            );

            return { status: response.data || 1, message: "Email is sent." };
        } catch (error) {
            return { status: false, message: "Email is not sent." };
        }
    },

    subscribedClientMail: async (reqBody) => {
        const toEmail = reqBody?.email;
        const encryptedEmail = encrypt(toEmail);
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear();
        const name = reqBody?.email.split("@")[0];
        const url = `${getUrl()}unsbscribeMail/${encryptedEmail?.data}`;

        const message = `
            <html xmlns="http://www.w3.org/1999/xhtml">
                <head>
                    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                    <meta name="viewport" content="width=device-width"/>
                    <title>Congratulations! Your subscription has been confirmed.</title>
                </head>
                <body style="padding:15px;">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td valign="top">
                                <table width="600" border="0" cellpadding="0" cellspacing="0" style="font-family: Arial, Helvetica, sans-serif; background-color: #f0e7de; border-radius: 15px;">
                                    <tr>
                                        <td width="100%" style="padding:30px; text-align: center;">
                                            <a href=${siteUrl} title="${siteName}">
                                            <img src="${companyImage}" alt=${siteName} style="max-width: 180px;"/>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" valign="top" bgcolor="#fff" style="padding:0px 20px;background-color: #f0e7de;">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="background-color: #fff; border-radius: 15px;">
                                                <tr>
                                                    <td style="padding: 25px;">
                                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                            <tr>
                                                                <td colspan="2"><b style="font-size: 18px; text-align: center;">Dear ${name},</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" valign="top">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size:16px; padding: 10px 0; text-align: left;">Thank you for subscribing to our newsletters.</td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size:16px; text-align: left;padding:10px 0;">Your subscription has been confirmed. You've been added to our list and will hear from us soon.</td>
                                                            </tr>
                                                                <td colspan="2" style="font-size:16px; text-align: left; padding:10px 0; font-weight: bold;">
                                                                    If you do not want to receive any future updates, please 
                                                                    <a href=${url} style="color: blue; text-decoration: underline;">click here</a>
                                                                    to unsubscribe.
                                                                </td>
            
                                                        </table>

                                                    </td>
                                                </tr>
                                           </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" valign="top">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="padding: 20px; text-align: center;">
                                                <tr>
                                                    <td style="font-size:18px; font-weight: 600; padding: 0 0 10px 0;">Best Regards,<br></td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 10px 0;">
                                                        <a href="${siteUrl}" target="_blank" title="@SITENAME" style="font-size: 16px;color: #1a1a1a;text-decoration: none;text-transform: uppercase;">${siteName}</a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><p style="text-align:center;font-size:16px;padding:10px  0px; margin: 0px;">Copyright © ${currentYear} ${siteName} All Rights Reserved.</p></td>
                                                </tr>
                                                
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>
            </html>
        `;

        const emailParams = {
            EmailTo: toEmail || "",
            Subject: "Congratulations! Your subscription has been confirmed.",
            Message: message,
            ReplyToEmail: "",
            RelpyToName: "Reply To Name",
            CcEmail: "",
            BccEmail: "",
            AllowAttachment: "png,PNG,pdf,PDF,xls,xlsx,csv",
            // Attachment: [pdfUrl], // Attach the PDF URL here
        };

        const returnObject = {
            EmailPara: JSON.stringify(emailParams),
            SiteId: process.env.NMAIL_SITE_ID,
            SiteTocken: process.env.NMAIL_SITE_TOKEN,
        };

        const headers = {
            Authorization: process.env.NMAIL_HEADER_TOKEN,
        };

        try {
            const response = await axios.post(
                process.env.NMAIL_URL,
                returnObject,
                {
                    headers,
                }
            );

            return { status: response.data || 1, message: "Email is sent." };
        } catch (error) {
            return { status: false, message: "Email is not sent." };
        }
    },

    subscribedAdminMail: async (reqBody) => {
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear();

        const message = `
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <meta name="viewport" content="width=device-width"/>
                <title>${siteName}</title>
            </head>
            <body style="padding:15px;">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td valign="top">
                            <table width="600" border="0" cellpadding="0" cellspacing="0" style="font-family: Arial, Helvetica, sans-serif; background-color: #f0e7de; border-radius: 15px;">
                                <tr>
                                    <td width="100%" style="padding:30px; text-align: center;" align="left">
                                        <a href="${siteUrl}" title="${siteName}">
                                            <img src="${companyImage}" alt="swadish" style="max-width: 180px;"/>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" valign="top" bgcolor="#fff" style="padding:0px 20px;background-color: #f0e7de;">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="background-color: #fff; border-radius: 15px;">
                                            <tr>
                                                <td style="padding: 25px;">

                                                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" >
                                                        <tr>
                                                            <td colspan="2"><b style="font-size:18px;">Dear Administrator,</b></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="center" valign="top">&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2" style="font-size:16px;">New web visitor ${reqBody?.email} has subscribed for our Newsletter.</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                       </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" valign="top">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="padding: 20px; text-align: center;">
                                            <tr>
                                                <td style="font-size:18px; font-weight: 600; padding: 0 0 10px 0;">Best Regards,<br>
                                            </tr>
                                            <tr>
                                                <td style="padding: 10px 0;">
                                                    <a href="${siteUrl}" target="_blank" title="${siteName}" style="font-size: 16px;color: #1a1a1a;text-decoration: none;text-transform: uppercase;">${siteName}</a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><p style="text-align:center;font-size:16px;padding:10px 0px; margin: 0px;">Copyright © ${currentYear} ${siteName} All Rights Reserved.</p></td>
                                            </tr>
                                            
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </body>
        </html>`;

        const emailParams = {
            EmailTo: process.env.CLIENT_NOTIFICATION_EMAIL || "",
            Subject: "Email Subscription Received for our Newsletter",
            Message: message,
            ReplyToEmail: "",
            RelpyToName: "Reply To Name",
            CcEmail: "",
            BccEmail: "",
            AllowAttachment: "png,PNG,pdf,PDF,xls,xlsx,csv",
        };

        const returnObject = {
            EmailPara: JSON.stringify(emailParams),
            SiteId: process.env.NMAIL_SITE_ID,
            SiteTocken: process.env.NMAIL_SITE_TOKEN,
        };

        const headers = {
            Authorization: process.env.NMAIL_HEADER_TOKEN,
        };

        try {
            const response = await axios.post(
                process.env.NMAIL_URL,
                returnObject,
                { headers }
            );
            return { status: response.data || 1, message: "Email is sent." };
        } catch (error) {
            return { status: false, message: "Email is not sent." };
        }
    },

    unsubscriptionAdminMail: async (reqBody) => {
        const toEmail = reqBody;
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear();
        const name = reqBody?.split("@")[0];
        const url = `${getUrl()}`;

        const emailTemplate = `
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <meta name="viewport" content="width=device-width"/>
                <title>Swadish World</title>
            </head>
            <body style="padding:15px;">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td valign="top">
                            <table width="600" border="0" cellpadding="0" cellspacing="0" style="font-family: Arial, Helvetica, sans-serif; background-color: #f0e7de; border-radius: 15px;">
                                <tr>
                                    <td width="100%" style="padding:30px; text-align: center;" align="left">
                                        <a href="${siteUrl}" title="${siteName}">
                                            <img src="${companyImage}" alt="swadish" style="max-width: 180px;"/>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" valign="top" bgcolor="#fff" style="padding:0px 20px;background-color: #f0e7de;">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="background-color: #fff; border-radius: 15px;">
                                            <tr>
                                                <td style="padding: 25px;">

                                                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                        <tr>
                                                            <td colspan="2"><b style="font-size:18px;">Dear ${name},</b></td>
                                                        </tr>
                                                        <br/>
                                                        <tr>
                                                            <td colspan="2" style="font-size:16px;">Thank You</td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2" style="font-size:16px;">You have been successfully removed from this subscriber list.</td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2" style="font-size:16px;">You will no longer hear from us.</td>
                                                        </tr>
                                                        <br/>
                                                        <tr>
                                                            <td align="left" valign="middle" style="font-family:Arial, Helvetica, sans-serif; font-size:16px; line-height:20px; color:#008000;">Did you unsubscribe by accident? Click here to re-subscribe.</td>
                                                        </tr>
                                                        <br/>
                                                        <tr>
                                                            <td align="left" valign="middle">
                                                                <a href="${url}" title="Re-Subscribe" target="_blank" style="font-family:Arial, Helvetica, sans-serif; font-size:16px; line-height:20px; font-weight:500; color: #2b2a29; text-decoration:none; padding:8px 30px; border-radius: 29px; background-color: #93c01d;">Re-Subscribe</a>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                       </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" valign="top">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="padding: 20px; text-align: center;">
                                            <tr>
                                                <td style="font-size:18px; font-weight: 600; padding: 0 0 10px 0;">Best Regards,<br></td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 10px 0;">
                                                    <a href="http://your-site-path.com" target="_blank" title="Swadish World" style="font-size: 16px;color: #1a1a1a;text-decoration: none;text-transform: uppercase;">Swadish World</a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><p style="text-align:center;font-size:16px;padding:10px  0px; margin: 0px;">Copyright © ${currentYear} ${siteName} All Rights Reserved.</p></td>
                                            </tr>
                                            
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </body>
        </html>`;

        const emailParams = {
            EmailTo: toEmail || "",
            Subject: "Unsubscribe Newsletter",
            Message: emailTemplate,
            ReplyToEmail: "",
            RelpyToName: "Reply To Name",
            CcEmail: "",
            BccEmail: "",
            AllowAttachment: "png,PNG,pdf,PDF,xls,xlsx,csv",
        };

        const returnObject = {
            EmailPara: JSON.stringify(emailParams),
            SiteId: process.env.NMAIL_SITE_ID,
            SiteTocken: process.env.NMAIL_SITE_TOKEN,
        };

        const headers = {
            Authorization: process.env.NMAIL_HEADER_TOKEN,
        };

        try {
            const response = await axios.post(
                process.env.NMAIL_URL,
                returnObject,
                { headers }
            );
            return { status: response.data || 1, message: "Email is sent." };
        } catch (error) {
            return { status: false, message: "Email is not sent." };
        }
    },

    //contact Us//
    contactAdminMail: async (reqBody) => {
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear();

        const emailTemplate = `
            <html xmlns="http://www.w3.org/1999/xhtml">
                <head>
                    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                    <meta name="viewport" content="width=device-width"/>
                    <title>${siteName}</title>
                </head>
                <body style="padding:15px;">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td valign="top">
                                <table width="600" border="0" cellpadding="0" cellspacing="0" style="font-family: Arial, Helvetica, sans-serif; background-color: #f0e7de; border-radius: 15px;">
                                    <tr>
                                        <td width="100%" style="padding:30px; text-align: center;" align="left">
                                            <a href="${siteUrl}" title="${siteName}">
                                                <img src="${companyImage}" alt="swadish" style="max-width: 180px;"/>
                                            </a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" valign="top" bgcolor="#fff" style="padding:0px 20px;background-color: #f0e7de;">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="background-color: #fff; border-radius: 15px;">
                                                <tr>
                                                    <td style="padding: 25px;">

                                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                            <tr>
                                                                <td colspan="2"><b style="font-size:25px;">Dear Admin,</b></td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center" valign="top">&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="font-size:16px;">${reqBody?.name} has contacted us, below are the details of that person.</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="font-size:20px;padding: 20px 0px; font-weight: 600;">Enquiry Details:</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Name: ${reqBody?.name}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Email: ${reqBody?.email}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Contact no.: ${reqBody?.mobile}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Product: ${reqBody?.product}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Comment: ${reqBody?.comment}</td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                           </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" valign="top">
                                            <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="padding: 20px;text-align:center">
                                                <tr>
                                                    <td style="font-size:18px;font-weight:600;padding:0 0 10px 0">Best Regards,<br>
                                                </tr>
                                                <tr>
                                                    <td style="padding:0px 0">
                                                        <a href="${siteUrl}" target="_blank" title="${siteName}" style="font-size: 18px;color: #272032;text-decoration: none;text-transform: uppercase;">${siteName}</a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><p style="text-align:center;font-size:16px;padding:0px 0px;margin:0px">Copyright © ${currentYear} ${siteName} All Rights Reserved.</p></td>
                                                </tr>
                                                
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </body>
            </html>
            `;

        const emailParams = {
            EmailTo: process.env.CLIENT_NOTIFICATION_EMAIL || "",
            Subject: "New Contact Enquiry Received",
            Message: emailTemplate,
            ReplyToEmail: "",
            RelpyToName: "Reply To Name",
            CcEmail: "",
            BccEmail: "",
            AllowAttachment: "png,PNG,pdf,PDF,xls,xlsx,csv",
        };

        const returnObject = {
            EmailPara: JSON.stringify(emailParams),
            SiteId: process.env.NMAIL_SITE_ID,
            SiteTocken: process.env.NMAIL_SITE_TOKEN,
        };

        const headers = {
            Authorization: process.env.NMAIL_HEADER_TOKEN,
        };

        try {
            const response = await axios.post(
                process.env.NMAIL_URL,
                returnObject,
                {
                    headers,
                }
            );
            return { status: response.data || 1, message: "Email is sent." };
        } catch (error) {
            return { status: false, message: "Email is not sent." };
        }
    },

    contactClientMail: async (reqBody) => {
        const toEmail = reqBody?.email;
        const currentDate = new Date();
        const currentYear = currentDate.getFullYear();

        const emailTemplate = `
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <meta name="viewport" content="width=device-width"/>
                <title>${siteName}</title>
            </head>
            <body style="padding:15px;">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td valign="top">
                            <table width="600" border="0" cellpadding="0" cellspacing="0" style="font-family: Arial, Helvetica, sans-serif; background-color: #f0e7de; border-radius: 15px;">
                                <tr>
                                    <td width="100%" style="padding:30px; text-align: center;">
                                        <a href="${siteUrl}" title="${siteName}">
                                            <img src="${companyImage}" alt=${siteName} style="max-width: 180px;"/>
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" valign="top" bgcolor="#fff" style="padding:0px 20px;background-color: #f0e7de;">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="background-color: #fff; border-radius: 15px;">
                                            <tr>
                                                <td style="padding: 25px;">

                                                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                                        <tr>
                                                            <td colspan="2"><b style="font-size: 25px; text-align: center;">Dear ${reqBody?.name},</b></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="center" valign="top">&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2" style="font-size:16px;">Thanks for contacting us.</td>
                                                        </tr>
                                                         <tr>
                                                                <td style="font-size:20px;padding: 20px 0px; font-weight: 600;">Enquiry Details:</td>
                                                         </tr>
                                                         <tr>
                                                                <td>Name: ${reqBody?.name}</td>
                                                         </tr>
                                                         <tr>
                                                                <td>Email: ${reqBody?.email}</td>
                                                         </tr>
                                                         <tr>
                                                                <td>Contact no.: ${reqBody?.mobile}</td>
                                                         </tr>
                                                            <tr>
                                                                <td>Product: ${reqBody?.product}</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Comment: ${reqBody?.comment}</td>
                                                            </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                       </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" valign="top">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="padding: 20px;text-align:center">
                                            <tr>
                                                <td style="font-size:18px;font-weight:600;padding:0 0 10px 0">Best Regards,<br></td>
                                            </tr>
                                            <tr>
                                                <td style="padding:0px 0">
                                                    <a href="${siteUrl}" target="_blank" title="${siteName}" style="font-size: 18px;color: #272032;text-decoration: none;text-transform: uppercase;">${siteName}</a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <p style="text-align:center;font-size:16px;padding:0px 0px;margin:0px">Copyright © ${currentYear} ${siteName} All Rights Reserved.</p>
                                                </td>
                                            </tr>
                                            
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </body>
        </html>
        `;

        const emailParams = {
            EmailTo: toEmail || "",
            Subject: "Swadish World - New Contact Enquiry Submitted Successfully",
            Message: emailTemplate,
            ReplyToEmail: "",
            RelpyToName: "Reply To Name",
            CcEmail: "",
            BccEmail: "",
            AllowAttachment: "png,PNG,pdf,PDF,xls,xlsx,csv",
        };

        const returnObject = {
            EmailPara: JSON.stringify(emailParams),
            SiteId: process.env.NMAIL_SITE_ID,
            SiteTocken: process.env.NMAIL_SITE_TOKEN,
        };

        const headers = {
            Authorization: process.env.NMAIL_HEADER_TOKEN,
        };

        try {
            const response = await axios.post(process.env.NMAIL_URL, returnObject, {
                headers,
            });
            return { status: response.data || 1, message: "Email is sent." };
        } catch (error) {
            return { status: false, message: "Email is not sent." };
        }
    },

};
